/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <dlfcn.h>
#include <src/machine/plugin/donnees/typeutilisateur.h>
using namespace SetLgg::Machine::Plugin;

TypeUtilisateur::TypeUtilisateur(const std::string& nom_type, const std::string& nom_plugin, void *plugin_handler)
:_nom_type(nom_type), _nom_plugin(nom_plugin)
{
	std::string fonction = "setlgg_machine_";
	fonction += nom_plugin;
	fonction += "_type_";
	fonction += nom_type;
	fonction += "_";
	_serialisation = reinterpret_cast<Serialisation>(::dlsym(plugin_handler,std::string(fonction+"serialise").c_str()));
	_deserialisation = reinterpret_cast<Deserialisation>(::dlsym(plugin_handler,std::string(fonction+"unserialise").c_str()));
	_destruction = reinterpret_cast<Destruction>(::dlsym(plugin_handler,std::string(fonction+"delete").c_str()));
	_copie = reinterpret_cast<Copie>(::dlsym(plugin_handler,std::string(fonction+"copy").c_str()));
	if(not _serialisation)
	{
		throw PluginFonctionManquanteType(nom_plugin,nom_type,std::string("char* ")+fonction+"serialise(const void*)");
	}
	if(not _deserialisation)
	{
		throw PluginFonctionManquanteType(nom_plugin,nom_type,std::string("void* ")+fonction+"unserialise(const char*)");
	}
	if(not _destruction)
	{
		throw PluginFonctionManquanteType(nom_plugin,nom_type,std::string("void ")+fonction+"delete(void*)");
	}
	if(not _copie)
	{
		throw PluginFonctionManquanteType(nom_plugin,nom_type,std::string("void* ")+fonction+"copy(const void*)");
	}
}
