/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __MACHINE_PLUGIN_DONNEES_TYPEUTILISATEUR_H__
#define __MACHINE_PLUGIN_DONNEES_TYPEUTILISATEUR_H__

#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Plugin { DECL_SHARED_PTR(TypeUtilisateur); } } }

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			namespace Outil
			{
				class MemoireUtilisateur;
			}
		}
		namespace Memoire
		{
			class Utilisateur;
		}
		namespace Plugin
		{
			class GestionnairePlugin;
			class DependanceType;
			class TypeUtilisateur
			{
				friend class GestionnairePlugin;
				friend class DependanceType;
				friend class Memoire::Utilisateur;
				friend class Programme::Outil::MemoireUtilisateur;
				public:
					typedef char* (*Serialisation)(const void *valeur);
					typedef void* (*Deserialisation)(const char *valeur);
					typedef void (*Destruction)(void *valeur);
					typedef void* (*Copie)(const void *valeur);
					TypeUtilisateur(const std::string& nom_type, const std::string& nom_plugin, void *plugin_handler);
				private:
					const std::string _nom_type;
					const std::string _nom_plugin;
					Serialisation _serialisation;
					Deserialisation _deserialisation;
					Destruction _destruction;
					Copie _copie;
			};

			class PluginFonctionManquanteType : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginFonctionManquanteType(const std::string& nom_plugin, const std::string& nom_type, const std::string& prototype)
					:Integration(std::string("Missing function ")+prototype+" for type "+nom_type+" in plugin "+nom_plugin) {};
			};
		}
	}
}

#endif
