#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <src/plugin.h>

#ifdef __cplusplus
extern "C"
{
#endif

void plugin_configuration(void *plugin)
{
	setlgg_machine_plugin_register(plugin,
	"PLUGIN dummy "
	"CONTAINS "
	"	TYPE dummy "
	"	INSTRUCTION dummy INT STR RETURN "
	"	INSTRUCTION disp USR(dummy) NO RETURN "
	"END"
	);
}

char* setlgg_machine_dummy_type_dummy_serialise(const void *object)
{
	Dummy *dummy = (Dummy*)(object);
	char buffer[256];
	snprintf(buffer,255,"%d %le",dummy->_int,dummy->_double);
	char *result = strdup(buffer);
	return result;
}

void* setlgg_machine_dummy_type_dummy_unserialise(const char *string)
{
	int i;
	double d;
	sscanf(string,"%d %le",&i,&d);
	Dummy *dummy = malloc(sizeof(struct dummy));
	dummy->_int = i;
	dummy->_double = d;
	return dummy;
}

void setlgg_machine_dummy_type_dummy_delete(void *object)
{
	free(object);
}

void* setlgg_machine_dummy_type_dummy_copy(const void* object)
{
	Dummy *dummy = (Dummy*)(object);
	Dummy *copy = malloc(sizeof(struct dummy));
	copy->_int=dummy->_int;
	copy->_double=dummy->_double;
	return copy;
}

SetLgg_Machine_Value* setlgg_machine_dummy_instruction_dummy(void *machine, unsigned long int argc, SetLgg_Machine_Value argv[])
{
	int integer = argv[0]._value._integer;
	const char *string = argv[1]._value._string._buffer;
	Dummy *my_dummy = malloc(sizeof(struct dummy));
	my_dummy->_int = integer;
	double d = atof(string);
	my_dummy->_double=d;
	SetLgg_Machine_Value *result = setlgg_machine_value_new_usertype("dummy",my_dummy);
	return result;
}

SetLgg_Machine_Value* setlgg_machine_dummy_instruction_disp(void *machine, unsigned long int argc, SetLgg_Machine_Value argv[])
{
	Dummy *dummy = (Dummy*)(argv[0]._value._user_type);
	printf("Dummy: %d %f\n",dummy->_int,dummy->_double);
	return NULL;
}
#ifdef __cplusplus
}
#endif
