/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __SETLGG_MACHINE_PLUGIN__H__
#define __SETLGG_MACHINE_PLUGIN__H__

#include <setlgg_machine.h>

/*
 * Example of setlgg machine plugin.
 * To test this plugin, you can use this simple program:
	:dummy 2 "3.1415" @&0 -> &0
 * with a memory file like:
#> &0 : USR(dummy) "0 0.0"
 *
 */
#ifdef __cplusplus
extern "C"
{
#endif

void plugin_configuration(void *plugin);

typedef struct dummy
{
	int _int;
	double _double;
} Dummy;

char* setlgg_machine_dummy_type_dummy_serialise(const void *object);
void* setlgg_machine_dummy_type_dummy_unserialise(const char *string);
void setlgg_machine_dummy_type_dummy_delete(void *object);
void* setlgg_machine_dummy_type_dummy_copy(const void *object);

SetLgg_Machine_Value* setlgg_machine_dummy_instruction_dummy(void *machine, unsigned long int argc, SetLgg_Machine_Value argv[]);
SetLgg_Machine_Value* setlgg_machine_dummy_instruction_disp(void *machine, unsigned long int argc, SetLgg_Machine_Value argv[]);

#ifdef __cplusplus
}
#endif
#endif
