/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <signal.h>
#include <string.h>
#include <sstream>
#include <iostream>
#include <vector>
#include <src/machine/plugin/officiels/dynlib.h>

extern "C"
{
void plugin_configuration(void *plugin_handler)
{
	::setlgg_machine_plugin_register(plugin_handler,
		"PLUGIN dynlib "
		"CONTAINS "
		"   INSTRUCTION library IOR NO RETURN "
		"END"
	);
}

SetLgg_Machine_Value* setlgg_machine_dynlib_instruction_library(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
{
	SetLgg_Machine_ReturnValue nom_bibliotheque = ::setlgg_machine_internal_stream_name(machine,parametres[0]._value._inoutref);
	if(nom_bibliotheque._return!=SetLgg_Machine_Return::OK)
	{
		::setlgg_machine_error(machine,SIGILL,"Inexistant library stream");
	}
	SetLgg_Machine_String format = {"s", 1};
	SetLgg_Machine_ReturnValue code_bibliotheque = ::setlgg_machine_stream_read(machine,parametres[0]._value._inoutref,format,SetLgg_Machine_ReadMode::ALL,0);
	if(code_bibliotheque._return!=SetLgg_Machine_Return::OK)
	{
		std::ostringstream message;
		message << "Invalid library stream " << SETLGG_MACHINE_VALUE_TO_CPP_STRING(nom_bibliotheque._value);
		::setlgg_machine_return_value_delete(&nom_bibliotheque);
		::setlgg_machine_error(machine,SIGILL,message.str().c_str());
	}
	SetLgg_Machine_ReturnProgram compilation = ::setlgg_machine_internal_program_compile(machine,code_bibliotheque._value._value._string);
	if(compilation._return!=SetLgg_Machine_Return::OK)
	{
		std::ostringstream message;
		message << "Invalid library code in stream " << SETLGG_MACHINE_VALUE_TO_CPP_STRING(nom_bibliotheque._value);
		::setlgg_machine_return_value_delete(&code_bibliotheque);
		::setlgg_machine_return_value_delete(&nom_bibliotheque);
		::setlgg_machine_error(machine,SIGILL,message.str().c_str());
	}
	::setlgg_machine_internal_program_append(machine,compilation._program);
	::setlgg_machine_return_value_delete(&code_bibliotheque);
	::setlgg_machine_return_value_delete(&nom_bibliotheque);
	::setlgg_machine_internal_program_destruct(compilation._program);
	return NULL;
}

}
