/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __SETLGG_MACHINE_PLUGIN_OFFICIEL_DYNLIB_H__
#define __SETLGG_MACHINE_PLUGIN_OFFICIEL_DYNLIB_H__

#include <src/machine/plugin/interface/setlgg_machine.h>

extern "C"
{
	void plugin_configuration(void *plugin_handler);
	
	/*
	 * This instruction :library takes one IOR in argument.
	 * It will read all the data accessible in the given stream, compiles the content and appends the result to the current program.
	 * After this, all labels declared in the library can be called as functions:
	 * - statically:
	 *   You have to declare the label in the main program, it will be overwritten at library load.
	 *   :label lib_dummy_function
	 *   :library $lib_dummy
	 *   ...
	 *   :call lib_dummy_function parameters
	 * - dynamically:
	 *   :library $lib_dummy
	 *   ...
	 *   :call "lib_dummy_function" parameters
	 */
	SetLgg_Machine_Value* setlgg_machine_dynlib_instruction_library(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);
}

#endif
