/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <sstream>
#include <iostream>
#include <vector>
#include <src/machine/plugin/officiels/envvar.h>

extern "C"
{
void plugin_configuration(void *plugin_handler)
{
	::setlgg_machine_plugin_register(plugin_handler,
		"PLUGIN envvar "
		"CONTAINS "
		"   INSTRUCTION getenvvar STR RETURN "
		"   INSTRUCTION setenvvar STR STR NO RETURN "
		"   INSTRUCTION addenvvar STR STR NO RETURN "
		"   INSTRUCTION delenvvar STR NO RETURN "
		"   INSTRUCTION listenvvar RETURN "
		"END"
	);
}
SetLgg_Machine_Value* setlgg_machine_envvar_instruction_getenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
{
	SETLGG_MACHINE_VARIABLE_VALUE_TO_CPP_STRING(nom,parametres[0]);
	char *resultat=::getenv(nom.c_str());
	if(resultat==NULL)
	{
		::SetLgg_Machine_Value *retour = ::setlgg_machine_value_new_null_string();
		return retour;
	}
	else
	{
		::SetLgg_Machine_Value *retour = ::setlgg_machine_value_new_string(resultat);
		return retour;
	}
}

SetLgg_Machine_Value* setlgg_machine_envvar_instruction_setenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
{
	SETLGG_MACHINE_VARIABLE_VALUE_TO_CPP_STRING(nom,parametres[0]);
	SETLGG_MACHINE_VARIABLE_VALUE_TO_CPP_STRING(valeur,parametres[1]);
	int resultat=::setenv(nom.c_str(),valeur.c_str(),1);
	if(resultat<0)
	{
		::setlgg_machine_error(machine,SIGABRT,"Impossible to set the environment variable");
	}
	return NULL;
}

SetLgg_Machine_Value* setlgg_machine_envvar_instruction_addenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
{
	SETLGG_MACHINE_VARIABLE_VALUE_TO_CPP_STRING(nom,parametres[0]);
	SETLGG_MACHINE_VARIABLE_VALUE_TO_CPP_STRING(valeur,parametres[1]);
	int resultat=::setenv(nom.c_str(),valeur.c_str(),0);
	if(resultat<0)
	{
		::setlgg_machine_error(machine,SIGABRT,"Impossible to add the environment variable");
	}
	return NULL;
}

SetLgg_Machine_Value* setlgg_machine_envvar_instruction_delenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
{
	SETLGG_MACHINE_VARIABLE_VALUE_TO_CPP_STRING(nom,parametres[0]);
	int resultat=::unsetenv(nom.c_str());
	if(resultat<0)
	{
		::setlgg_machine_error(machine,SIGABRT,"Impossible to delete the environment variable");
	}
	return NULL;
}

SetLgg_Machine_Value* setlgg_machine_envvar_instruction_listenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
{
	size_t taille=0;
	for(char **index=::environ ; (*index)!=NULL ; ++index)
	{
		++taille;
	}
	SetLgg_Machine_ValueType integer;
	integer._type = VALUE_INTEGER;
	SetLgg_Machine_ValueType string;
	string._type = VALUE_STRING;
	SetLgg_Machine_MemoryTypedBloc memoire[] = { { integer, 1}, { string, 2*taille+1} };
	size_t adresse = ::setlgg_machine_memory_new(machine,2,memoire);
	SetLgg_Machine_Value* valeur_taille = ::setlgg_machine_value_new_integer(2*taille+2);
	::setlgg_machine_memory_write_address(machine,adresse,*valeur_taille);
	::setlgg_machine_value_delete(valeur_taille);
	SetLgg_Machine_Value *retour = ::setlgg_machine_value_new_pointer(adresse);
	for(size_t index=0 ; index<taille ; ++index)
	{
		size_t taille_nom = 0;
		for(char *index_nom=environ[index] ; *index_nom!='=' ; ++index_nom)
		{
			++taille_nom;
		}
		SetLgg_Machine_Value* nom = ::setlgg_machine_value_new_sized_string(environ[index],taille_nom);
		::setlgg_machine_memory_write_address(machine,adresse+1+2*index,*nom);
		::setlgg_machine_value_delete(nom);
		SetLgg_Machine_Value* valeur = ::setlgg_machine_value_new_string(environ[index]+taille_nom+1);
		::setlgg_machine_memory_write_address(machine,adresse+1+2*index+1,*valeur);
		::setlgg_machine_value_delete(valeur);
		
	}
	return retour;

}

}
