/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __SETLGG_MACHINE_PLUGIN_OFFICIEL_ENVVAR_H__
#define __SETLGG_MACHINE_PLUGIN_OFFICIEL_ENVVAR_H__

#include <src/machine/plugin/interface/setlgg_machine.h>

extern "C"
{
	void plugin_configuration(void *plugin_handler);
	
	/*
	 * This instruction :getenvvar takes one STR in argument.
	 * The instruction returns the value of the environement variable as a STR value, or the null string when the variable does not exist.
	 */
	SetLgg_Machine_Value* setlgg_machine_envvar_instruction_getenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * This instruction :setenvvar takes two STR in argument.
	 * The instruction will erase the value or create a new environment variable using the first STR as name and the second STR as value.
	 * The instruction raises an ABRT interruption if the variable change fails.
	 */
	SetLgg_Machine_Value* setlgg_machine_envvar_instruction_setenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * This instruction :addenvvar takes two STR in argument.
	 * The instruction will create a new environment variable using the first STR as name and the second STR as value. If the variable already exist, this instruction has no effect.
	 * The instruction raises an ABRT interruption if the variable change fails.
	 */
	SetLgg_Machine_Value* setlgg_machine_envvar_instruction_addenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * This instruction :delenvvar takes one STR in argument.
	 * The instruction will delete the environment variable using the first STR as name. If the variable does not exist, this instruction has no effect.
	 */
	SetLgg_Machine_Value* setlgg_machine_envvar_instruction_delenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * This instruction :listenvvar takes no argument.
	 * The instruction returns a pointer on an array containing all environment variables:
	 * INT size of the array
	 * STR name of the first variable
	 * STR value of the first variable
	 * ...
	 * STR name of the last variable
	 * STR value of the last variable
	 * STR
	 *
	 * To delete this array, please consider this code:
	 * :new PTR/environ
	 * :listenvvar -> environ
	 * ...
	 * :delete environ, &@environ*@&@environ
	 */
	SetLgg_Machine_Value* setlgg_machine_envvar_instruction_listenvvar(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);

}

#endif
