/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <signal.h>
#include <cmath>
#include <src/machine/plugin/officiels/maths.h>

extern "C"
{
void plugin_configuration(void *plugin_handler)
{
	::setlgg_machine_plugin_register(plugin_handler,
		"PLUGIN maths "
		"DEPENDS ON "
			"PLUGIN real "
			"TYPE real IN real "
		"END "
		"CONTAINS "
			"INSTRUCTION real_pi RETURN "
			"INSTRUCTION real_cosinus USR(real) RETURN "
			"INSTRUCTION real_sinus USR(real) RETURN "
			"INSTRUCTION real_tangent USR(real) RETURN "
			"INSTRUCTION real_arccosinus USR(real) RETURN "
			"INSTRUCTION real_arcsinus USR(real) RETURN "
			"INSTRUCTION real_arctangent USR(real) RETURN "
			"INSTRUCTION real_logarithm USR(real) RETURN "
			"INSTRUCTION real_exponential USR(real) RETURN "
			"INSTRUCTION real_square_root USR(real) RETURN "
		"END"
	);
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_pi(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = M_PI;
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_cosinus(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::cos(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_sinus(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::sin(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_tangent(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::tan(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_arccosinus(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	if((reel<-1) or (reel>1))
	{
		::setlgg_machine_error(machine,SIGFPE,"Invalid argument to arccosinus");
	}
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::acos(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_arcsinus(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	if((reel<-1) or (reel>1))
	{
		::setlgg_machine_error(machine,SIGFPE,"Invalid argument to arcsinus");
	}
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::asin(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_arctangent(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::atan(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_logarithm(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	if(reel<=0)
	{
		::setlgg_machine_error(machine,SIGFPE,"Invalid argument to logarithm");
	}
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::log(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_exponential(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::exp(reel);
	return resultat;
}

SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_square_root(void *machine, unsigned long int nb_parametres , SetLgg_Machine_Value parametres[])
{
	double reel = *reinterpret_cast<double*>(parametres[0]._value._user_type);
	if(reel<0)
	{
		::setlgg_machine_error(machine,SIGFPE,"Invalid argument to square root");
	}
	SetLgg_Machine_Value *resultat = ::setlgg_machine_value_new_usertype("real",new double);
	*(reinterpret_cast<double*>(resultat->_value._user_type)) = ::sqrt(reel);
	return resultat;
}

}
