/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __SETLGG_MACHINE_PLUGIN_OFFICIEL_MATHS_H__
#define __SETLGG_MACHINE_PLUGIN_OFFICIEL_MATHS_H__

#include <src/machine/plugin/interface/setlgg_machine.h>

extern "C"
{
	void plugin_configuration(void *plugin_handler);
	
	/*
	 * :real_pi -> USR(real)
	 * returns pi
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_pi(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_cosinus USR(real) -> USR(real)
	 * returns the cosine of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_cosinus(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_sinus USR(real) -> USR(real)
	 * returns the sine of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_sinus(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_tangent USR(real) -> USR(real)
	 * returns the tangent of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_tangent(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_arccosinus USR(real) -> USR(real)
	 * returns the inverse cosine of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_arccosinus(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_arcsinus USR(real) -> USR(real)
	 * returns the inverse sine of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_arcsinus(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_arctangent USR(real) -> USR(real)
	 * returns the inverse tangent of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_arctangent(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_logarithm USR(real) -> USR(real)
	 * returns the natural logarithm of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_logarithm(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_exponential USR(real) -> USR(real)
	 * returns the natural exponential of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_exponential(void*,unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_square_root USR(real) -> USR(real)
	 * returns the square root of the real
	 */
	SetLgg_Machine_Value* setlgg_machine_maths_instruction_real_square_root(void*,unsigned long int, SetLgg_Machine_Value[]);
}

#endif
