/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __SETLGG_MACHINE_PLUGIN_OFFICIEL_REAL_H__
#define __SETLGG_MACHINE_PLUGIN_OFFICIEL_REAL_H__

#include <src/machine/plugin/interface/setlgg_machine.h>

extern "C"
{
	void plugin_configuration(void *plugin_handler);
	
	char* setlgg_machine_real_type_real_serialise(const void*);
	void* setlgg_machine_real_type_real_unserialise(const char*);
	void setlgg_machine_real_type_real_delete(void*);
	void* setlgg_machine_real_type_real_copy(const void*);

	/*
	 * :real_addition USR(real) USR(real) -> USR(real)
	 * returns the sum of two reals
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_addition(void *, unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_substraction USR(real) USR(real) -> USR(real)
	 * returns the difference of two reals
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_substraction(void *, unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_multiplication USR(real) USR(real) -> USR(real)
	 * returns the product of two reals
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_multiplication(void *, unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_division USR(real) USR(real) -> USR(real)
	 * returns the quotient of two reals, or raise the FPE interruption if the divisor is null
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_division(void *, unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_negation USR(real) -> USR(real)
	 * returns the opposite real
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_negation(void *, unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_zero USR(real) STR
	 * jumps to the label in the string if the real is around zero
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_zero(void *, unsigned long int, SetLgg_Machine_Value[]);
	/*
	 * :real_positive USR(real) STR
	 * jumps to the label in the string if the real is positive
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_positive(void *, unsigned long int, SetLgg_Machine_Value[]);

	/*
	 * :int_to_real INT -> USR(real)
	 * :str_to_real STR -> USR(real)
	 * :real_to_int USR(real) -> INT
	 * :real_to_str USR(real) -> STR
	 * are conversion instructions
	 */
	SetLgg_Machine_Value* setlgg_machine_real_instruction_int_to_real(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);
	SetLgg_Machine_Value* setlgg_machine_real_instruction_str_to_real(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_to_int(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);
	SetLgg_Machine_Value* setlgg_machine_real_instruction_real_to_str(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);


}

#endif
