/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <sstream>
#include <iostream>
#include <vector>
#include <src/machine/plugin/officiels/streams.h>

extern "C"
{
void plugin_configuration(void *plugin_handler)
{
	::setlgg_machine_plugin_register(plugin_handler,
		"PLUGIN streams "
		"CONTAINS "
		"   INSTRUCTION string_stream IOR NO RETURN "
		"END"
	);
}

//SetLgg_Machine_Value* setlgg_machine_streams_instruction_fixed_read(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
//{
//	SetLgg_Machine_ReturnValue nom_flux = ::setlgg_machine_internal_stream_name(machine,parametres[0]._value._inoutref);
//	if(nom_flux._return!=SetLgg_Machine_Return::OK)
//	{
//		::setlgg_machine_error(machine,SIGABRT,"Inexistant stream");
//	}
//	if(parametres[1]._value._integer<0)
//	{
//		::setlgg_machine_return_value_delete(&nom_flux);
//		::setlgg_machine_error(machine,SIGABRT,"Invalid fixed read length");
//	}
//	if(::setlgg_machine_stream_readable(machine,parametres[0]._value._inoutref)!=SetLgg_Machine_Return::OK)
//	{
//		std::ostringstream message;
//		message << "Invalid operation on stream " << SETLGG_MACHINE_VALUE_TO_CPP_STRING(nom_flux._value);
//		::setlgg_machine_return_value_delete(&nom_flux);
//		::setlgg_machine_error(machine,SIGILL,message.str().c_str());
//	}
//	char *tampon = new char[parametres[1]._value._integer+1];
//	SetLgg_Machine_ReturnValue deja_dans_tampon = ::setlgg_machine_internal_stream_buffer_get(machine,parametres[0]._value._inoutref,parametres[1]._value._integer);
//	if(deja_dans_tampon._return!=SetLgg_Machine_Return::OK)
//	{
//		delete [] tampon;
//		::setlgg_machine_return_value_delete(&nom_flux);
//		::setlgg_machine_error(machine,SIGABRT,"Invalid fixed read length");
//	}
//	auto taille_deja_dans_tampon = deja_dans_tampon._value._value._string._size;
//	::memcpy(tampon,deja_dans_tampon._value._value._string._buffer,taille_deja_dans_tampon);
//	::setlgg_machine_return_value_delete(&deja_dans_tampon);
//	SetLgg_Machine_ReturnValue flux_lecture_id = ::setlgg_machine_internal_stream_read_id(machine,parametres[0]._value._inoutref);
//	ssize_t taille_lue;
//	if((taille_lue=::read(flux_lecture_id._value._value._integer,tampon+taille_deja_dans_tampon,parametres[1]._value._integer-taille_deja_dans_tampon))<0)
//	{
//		std::ostringstream message;
//		message << "Invalid fixed read in stream " << SETLGG_MACHINE_VALUE_TO_CPP_STRING(nom_flux._value);
//		delete [] tampon;
//		::setlgg_machine_return_value_delete(&flux_lecture_id);
//		::setlgg_machine_return_value_delete(&nom_flux);
//		::setlgg_machine_error(machine,SIGPIPE,message.str().c_str());
//	}
//	SetLgg_Machine_Value *retour=::setlgg_machine_value_new_sized_string(tampon,taille_deja_dans_tampon+taille_lue);
//	delete [] tampon;
//	::setlgg_machine_return_value_delete(&flux_lecture_id);
//	::setlgg_machine_return_value_delete(&nom_flux);
//	return retour;
//}

SetLgg_Machine_Value* setlgg_machine_streams_instruction_string_stream(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[])
{
	int tube[2];
	if(::pipe(tube)<0)
	{
		std::ostringstream message;
		message << "Impossible to open string stream." << std::endl << "pipe: " << ::strerror(errno);
		::setlgg_machine_error(machine,SIGPIPE,message.str().c_str());
	}
	switch(::setlgg_machine_internal_stream_register_pipe(machine,parametres[0]._value._inoutref,tube[0],tube[1]))
	{
		case SetLgg_Machine_Return::OK:
			return NULL;
		case SetLgg_Machine_Return::STREAM_ALREADY_EXISTS:
			{
				::close(tube[0]);
				::close(tube[1]);
				::setlgg_machine_error(machine,SIGPIPE,"String stream already exists");
			}
		default:
			throw;

	}
	throw;
}
}
