/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __SETLGG_MACHINE_PLUGIN_OFFICIEL_STREAMS_H__
#define __SETLGG_MACHINE_PLUGIN_OFFICIEL_STREAMS_H__

#include <src/machine/plugin/interface/setlgg_machine.h>

extern "C"
{
	void plugin_configuration(void *plugin_handler);
	
	/*
	 * This instruction :fixed_read takes one IOR and an INT in argument.
	 * The instruction will perform a low level read of a fixed length on the stream referenced by the IOR.
	 * The instruction returns the data in a STR type.
	 */
	//SetLgg_Machine_Value* setlgg_machine_streams_instruction_fixed_read(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * This instruction :string_stream takes one IOR in argument.
	 * The instruction will open a anonymous pipe stream to manipulate strings using the formatting facilities of :read and :write.
	 * The resulting stream is not seekable.
	 */
	SetLgg_Machine_Value* setlgg_machine_streams_instruction_string_stream(void *machine, unsigned long nb_parametres, SetLgg_Machine_Value parametres[]);

}

#endif
