/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __SETLGG_MACHINE_PLUGIN_OFFICIEL_STRINGS_H__
#define __SETLGG_MACHINE_PLUGIN_OFFICIEL_STRINGS_H__

#include <src/machine/plugin/interface/setlgg_machine.h>

extern "C"
{
	void plugin_configuration(void *plugin_handler);
	
	/*
	 * :strings_regex STR STR INT -> PTR
	 * The first string is the text string, the second one is the pattern string, and the integer is the maximum number of subgroups got by the pattern.
	 * The instruction replies by the address of a vector:
	 * - the first element is an integer containing the number of pointers following this integer
	 * - the following elements are pointers to vectors, each vector representing a match of the pattern in the text string.
	 * For each match, the subvector is made of:
	 * - the first element is an integer containing the number of strings following this integer
	 * - the following elements are strings. The first one is the text maching the pattern, and then the text maching subgroups in the pattern.
	 */
	SetLgg_Machine_Value* setlgg_machine_strings_instruction_strings_regex(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * :strings_substitute STR STR INT STR -> STR
	 * This instruction replaces in the first string the text matching:
	 * - the whole pattern in the second string when the third argument is 0,
	 * - the n-th subgroup in the pattern when the third argument is greather than 0.
	 * The last argument is the string used to replace the matching text.
	 * All matching text is replaced by the instruction.
	 */
	SetLgg_Machine_Value* setlgg_machine_strings_instruction_strings_substitute(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * :strings_split STR STR -> PTR
	 * This instruction splits the first string using the second one as a separator. The second string is a pattern used to find the separators.
	 * The instruction replies by an address on a vector:
	 * - the first element is an integer that contains the number of following elements,
	 * - the following elements are strings containing the text between the separators.
	 */
	SetLgg_Machine_Value* setlgg_machine_strings_instruction_strings_split(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);

	/*
	 * :strings_token STR STR ADDRESS -> STR
	 * This instruction returns from the string located at the address a token matching the first parameter.
	 * The token and the blank following the token matching the second parameter are extracted from the string located at the address.
	 */
	SetLgg_Machine_Value* setlgg_machine_strings_instruction_strings_split(void *machine, unsigned long int nb_parametres, SetLgg_Machine_Value parametres[]);

}

#endif
