/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/processeur/allocation_memoire.h>
using namespace SetLgg::Machine::Processeur;

void AllocationMemoire::allocation(const SetLgg::Machine::Memoire::Memoire::BlocMemoire& bloc)
{
	if((_allocations.empty()) or ((not _allocations.empty()) and (_allocations.back()._type!=Allocation::Type::NEW)))
	{
		Allocation allocation(Allocation::Type::NEW);
		allocation += bloc;
		_allocations.push_back(allocation);
		compacter();
		return;
	}
	_allocations.back() += bloc;
}

void AllocationMemoire::liberation(const SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire& blocs)
{
	if(_allocations.empty())
		return; // la premiere allocation n'est pas un delete !
	if((not _allocations.empty()) and (_allocations.back()._type!=Allocation::Type::DELETE))
	{
		Allocation allocation(Allocation::Type::DELETE);
		allocation += blocs._blocs_memoire;
		_allocations.push_back(allocation);
		compacter();
		return;
	}
	_allocations.back() += blocs;
}

AllocationMemoire::operator SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire () const
{
	SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire blocs;
	for(auto allocation:_allocations)
	{
		auto b = SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire::agregation(allocation._blocs);
		switch(allocation._type)
		{
			case Allocation::Type::NEW:
				blocs += b;
				blocs = SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire::agregation(blocs);
				break;
			case Allocation::Type::DELETE:
				blocs -= b;
				break;
			default:
				throw;
				break;
		}
	}
#ifdef SETLGG_DEBUG
SETLGG_TRACE	<< blocs << std::endl;
#endif

	return blocs;
}

void AllocationMemoire::compacter()
{
	if(_allocations.size()<1024)
		return;
	SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire blocs_equivalents = *this;
	Allocation allocation(Allocation::Type::NEW);
	allocation += blocs_equivalents;
	decltype(_allocations) nouvelles;
	nouvelles.push_back(allocation);
	_allocations.swap(nouvelles);
}
