/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_ALLOCATION_MEMOIRE_H_
#define _MACHINE_PROCESSEUR_ALLOCATION_MEMOIRE_H_

#include <list>
#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(AllocationMemoire); } } }

#include <src/machine/memoire/donnees/memoire.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Processeur
		{
			class AllocationMemoire
			{
				public:
					struct Allocation
					{
						typedef std::list<Allocation> Collection;
						typedef enum class { NEW, DELETE } Type;
						Allocation(const Allocation::Type type)
						:_type(type) { }
						template<typename Blocs>
						Allocation& operator+=(const Blocs& blocs)
						{
							_blocs += blocs;
							return *this;
						}
						template<typename oStream>
							friend oStream& operator<<(oStream& os,const Allocation& allocation)
						{
							os << "#      " ;
							switch(allocation._type)
							{
								case Type::NEW:
									os << ":new";
									break;
								case Type::DELETE:
									os << ":delete";
									break;
								default:
									throw;
									break;
							}
							for(auto it = allocation._blocs.cbegin() ; it!=allocation._blocs.cend() ; ++it)
							{
								os << " " << (*it);
							}
							os << std::endl;
							return os;
						}
						Allocation::Type _type;
						SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire _blocs;
					};

					AllocationMemoire() = default;
					void allocation(const SetLgg::Machine::Memoire::Memoire::BlocMemoire& bloc);
					void liberation(const SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire& blocs);
					operator SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire () const;
					void nettoie() { _allocations.clear(); }
					template<typename oStream>
					friend oStream& operator<<(oStream&,const AllocationMemoire&);
				private:
					Allocation::Collection _allocations;
					void compacter();
					
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const AllocationMemoire& allocations)
			{
				os << "#   Memory allocations:" << std::endl;
				for(auto a:allocations._allocations)
				{
					os << a;
				}
				os << "#   End of memory allocations" << std::endl;
				return os;
			}
		}
	}
}

#endif
