/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_ETAT_H_
#define _MACHINE_PROCESSEUR_ETAT_H_

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(Etat); } } }

#include <src/machine/memoire/donnees/adresse.h>
#include <src/machine/programme/donnees/adresse.h>
#include <src/machine/processeur/marqueurs.h>
#include <src/machine/processeur/allocation_memoire.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionAllocation;
			class InstructionLiberation;
			class InstructionRetour;
		}
		namespace Processeur
		{
			class Processeur;
			class Etat
			{
				friend class Processeur;
				friend class Programme::InstructionAllocation;
				friend class Programme::InstructionLiberation;
				friend class Programme::InstructionRetour;
				public:
					Etat() = default;
					Etat(const SetLgg::Machine::Programme::Adresse& prochaine_instruction, const SetLgg::Machine::Memoire::Adresse& adresse_courante)
					:_prochaine_instruction(prochaine_instruction), _adresse_courante(adresse_courante) {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Etat&);
					operator SetLgg::Machine::Programme::Adresse () const
					{
						return _prochaine_instruction;
					};
					operator SetLgg::Machine::Memoire::Adresse () const
					{
						return _adresse_courante;
					};
					void prochaine_instruction(const SetLgg::Machine::Programme::Adresse& label)
					{
						//_instruction_courante_debug=_prochaine_instruction; // si on ajoute cette ligne, l'instruction courante est mal renseignee lors d'un saut
						_prochaine_instruction = label;
					};
					void prochaine_instruction(const SetLgg::Machine::Programme::Adresse& label, const SetLgg::Machine::Memoire::Adresse& parametres)
					{
						//_instruction_courante_debug=_prochaine_instruction; // si on ajoute cette ligne, l'instruction courante est mal renseignee lors d'un saut
						_prochaine_instruction = label;
						_adresse_courante = parametres;
					};
					void prochaine_instruction()
					{
						_instruction_courante_debug=_prochaine_instruction; // debug
						++_prochaine_instruction;
					};
					void nettoie()
					{
						_marqueurs.nettoie();
						_allocation_memoire.nettoie();
					};
				private:
					SetLgg::Machine::Programme::Adresse _instruction_courante_debug; // debug
					SetLgg::Machine::Programme::Adresse _prochaine_instruction;
					SetLgg::Machine::Memoire::Adresse _adresse_courante;
					SetLgg::Machine::Processeur::Marqueurs _marqueurs;
					SetLgg::Machine::Processeur::AllocationMemoire _allocation_memoire;
					void change_adresse_courante(const SetLgg::Machine::Memoire::Adresse& adresse)
					{
						_adresse_courante = adresse;
					};
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const Etat& etat)
			{
				os	<< "# State:" << std::endl
					<< "#   Next instruction: " << etat._prochaine_instruction << " (Current instruction is " << etat._instruction_courante_debug << ")" << std::endl
					<< "#   Current address: " << etat._adresse_courante << std::endl
					<< etat._marqueurs
					<< etat._allocation_memoire
					<< "# End of state" << std::endl;
				return os;
			}
		}
	}
}

#endif
