/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_GESTIONNAIREINTERRUPTIONS_H_
#define _MACHINE_PROCESSEUR_GESTIONNAIREINTERRUPTIONS_H_

#include <vector>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(GestionnaireInterruptions); } } }

#include <src/machine/processeur/interruptions.h>
#include <src/machine/processeur/interruptionsenattente.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			DECL_SHARED_PTR(Adresse);
		}
		namespace Debogueur
		{
			class Debogueur;
		}
		namespace Processeur
		{
			DECL_SHARED_PTR(Processeur); DECL_WEAK_PTR(Processeur);
			class GestionnaireInterruptions
			{
				friend class Debogueur::Debogueur;
				public:
					struct GestionnaireInterruptionsResident
					{
							static GestionnaireInterruptionsResident* instance()
							{
								static GestionnaireInterruptionsResident gestionnaire;
								return &gestionnaire;
							}
							static void gestion_signal(int signal);
							static void consomme_enfants(int signal);
							SetLgg::Machine::Processeur::ProcesseurWP _processeur;
						private:
							GestionnaireInterruptionsResident() {};
					};
					GestionnaireInterruptions() = default;
					static void enregistrement_signaux(SetLgg::Machine::Processeur::ProcesseurSP& processeur);
					template<typename oStream>
					friend oStream& operator<<(oStream&,const GestionnaireInterruptions&);
					bool interruption(const size_t& interruption);
					SetLgg::Machine::Programme::AdresseSP operator[](const size_t& interruption) const
					{
						return _interruptions[interruption];
					};
					InterruptionsEnAttente::ListeInterruptions interruptions_en_attente()
					{
						return _interruptions_en_attente.consommation();
					};
					bool modifier_interruption(const size_t& interruption, const SetLgg::Machine::Programme::AdresseSP& adresse_interruption);
				private:
					Interruptions _interruptions;
					InterruptionsEnAttente _interruptions_en_attente;
					static bool valide_interruption(const size_t interruption);
					static std::set<size_t> interruptions_supportees();
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const GestionnaireInterruptions& interruptions)
			{
				return os << "# Interruption handler:" << std::endl << interruptions._interruptions << interruptions._interruptions_en_attente << "# End of interruption handler" << std::endl;
			}
		}
	}
}

#endif
