/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_INTERRUPTIONS_H_
#define _MACHINE_PROCESSEUR_INTERRUPTIONS_H_

#include <map>
#include <vector>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(Interruptions); } } }

#include <src/machine/programme/donnees/adresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Processeur
		{
			typedef std::vector<size_t> VecteurInterruption;
			class Interruptions
			{
				public:
					Interruptions() = default;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Interruptions&);
					SetLgg::Machine::Programme::AdresseSP operator[](const size_t& interruption) const
					{
						auto it=_interruptions.find(interruption);
						if((it==_interruptions.end()) or (it->second.empty()))
							return SetLgg::Machine::Programme::AdresseSP();
						SetLgg::Machine::Programme::AdresseSP adresse(new SetLgg::Machine::Programme::Adresse(it->second.back()));
						return adresse;
					}
					// les deux fonctions renvoient vrai s'il reste une interruption, et faux s'il n'y a plus d'interruption valide
					bool ajoute(const size_t& interruption, const SetLgg::Machine::Programme::Adresse& adresse);
					bool enleve(const size_t& interruption);
				private:
					typedef std::vector<SetLgg::Machine::Programme::Adresse> PileInterruptions;
					std::map<size_t, PileInterruptions> _interruptions;
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const Interruptions& interruptions)
			{
				os << "# Interruptions:" << std::endl;
				for(auto interruption=interruptions._interruptions.cbegin() ; interruption!=interruptions._interruptions.cend() ; ++interruption)
				{
					os << "#   Signal " << SetLgg::Global::Exception::Execution::nom_interruption(interruption->first) << ":";
					for(auto adresse=interruption->second.crbegin() ; adresse!=interruption->second.crend() ; ++adresse)
					{
						os << " " << *adresse;
					}
					os << std::endl;
				}
				return os << "# End of interruptions" << std::endl;
			}
		}
	}
}

#endif
