/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_FILEINTERRUPTIONS_H_
#define _MACHINE_PROCESSEUR_FILEINTERRUPTIONS_H_

#include <vector>

#include <src/machine/processeur/iterable_stack.h>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(InterruptionsEnAttente); } } }

namespace SetLgg
{
	namespace Machine
	{
		namespace Debogueur
		{
			class Debogueur;
		}
		namespace Processeur
		{
			class InterruptionsEnAttente
			{
				friend class Debogueur::Debogueur;
				public:
					typedef extended_std::iterable_stack<size_t,std::vector<size_t> > ListeInterruptions;
					InterruptionsEnAttente() = default;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InterruptionsEnAttente&);
					void ajout(const size_t& interruption)
					{
						_interruptions.push(interruption);
					};
					ListeInterruptions consommation()
					{
						if(_interruptions.empty())
							return ListeInterruptions();
						ListeInterruptions l=_interruptions;
						_interruptions = ListeInterruptions();
						return l;
					};
				private:
					ListeInterruptions _interruptions;
					template<typename oStream>
					friend oStream& operator<(oStream& os,const InterruptionsEnAttente& interruptionsenattente)
					{
						InterruptionsEnAttente::ListeInterruptions l = interruptionsenattente._interruptions;
						for(auto interruption = l.crbegin() ; interruption!=l.crend() ; ++interruption)
						{
							os << " " << SetLgg::Global::Exception::Execution::nom_interruption(*interruption);
						}
						return os;
					}
					operator bool () const
					{
						return not _interruptions.empty();
					};

			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const InterruptionsEnAttente& interruptionsenattente)
			{
				os << "#   Waiting interruptions:" ;
				os < interruptionsenattente;
				os << std::endl;
				return os;
			}
		}
	}
}

#endif
