/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __ITERABLE_STACK_H__
#define __ITERABLE_STACK_H__

#include <stack>

namespace extended_std
{
	template<typename T, typename Container=std::deque<T> >
		class iterable_stack : public std::stack<T,Container>
	{
		public:
			typedef typename Container::reverse_iterator reverse_iterator;
			typedef typename Container::const_reverse_iterator const_reverse_iterator;

			reverse_iterator rbegin() { return this->c.rbegin(); }
			reverse_iterator rend() { return this->c.rend(); }
			const_reverse_iterator crbegin() const { return this->c.rbegin(); }
			const_reverse_iterator crend() const { return this->c.rend(); }
			template<typename oStream>
			friend oStream& operator<<(oStream& os, const iterable_stack<T,Container>& it_stack)
			{
				for(auto it = it_stack.crbegin() ; it!=it_stack.crend() ; ++it)
				{
					os << *it;
				}
				return os;
			};
	};
}
#endif

