/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_MARQUEURS_H_
#define _MACHINE_PROCESSEUR_MARQUEURS_H_

#include <map>
#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(Marqueurs); } } }

#include <src/machine/memoire/donnees/adresse.h>
#include <src/machine/programme/donnees/adresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Processeur
		{
			class Marqueurs
			{
				public:
					Marqueurs() = default;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Marqueurs&);
					void ajoute(const std::string& marqueur)
					{
						auto it = _marqueurs.find(marqueur);
						if(it==_marqueurs.end())
						{
							_marqueurs.insert(std::make_pair(marqueur,0));
						}
						else
						{
							++it->second;
						}
					}
					void enleve(const std::string& marqueur)
					{
						auto it = _marqueurs.find(marqueur);
						if(it==_marqueurs.end())
							return;
						if(it->second>0)
						{
							--it->second;
						}
						else
						{
							_marqueurs.erase(it);
						}
					}
					void nettoie()
					{
						_marqueurs.clear();
					}
					bool operator() (const std::string& marqueur) const
					{
						return _marqueurs.find(marqueur)!=_marqueurs.end();
					}
				private:
					std::map<std::string,size_t> _marqueurs;
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const Marqueurs& marqueurs)
			{
				if(not marqueurs._marqueurs.empty())
				{
					os	<< "#   Checkpoints:" << std::endl;
					for(auto marqueur:marqueurs._marqueurs)
					{
						os << "#       " << marqueur.first << ": " << marqueur.second << std::endl;
					}
					os	<< "#   End of checkpoints" << std::endl;
				}
				return os;
			}
		}
	}
}

#endif
