/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/processeur/pileetats.h>
using namespace SetLgg::Machine::Processeur;

void PileEtats::empile(const Etat& etat)
{
	_pile_etats.push(etat);
}

Etat PileEtats::depile()
{
	if(_pile_etats.empty())
	{
		throw TropDeRetoursDeFonction();
	}
	Etat etat = _pile_etats.top();
	_pile_etats.pop();
	return etat;
}

bool PileEtats::duplique()
{
	if(_pile_etats.empty())
		return false;
	auto etat = _pile_etats.top();
	_pile_etats.push(etat);
	return true;
}

bool PileEtats::elimine()
{
	if(_pile_etats.empty())
		return false;
	_pile_etats.pop();
	return true;
}

bool PileEtats::echange()
{
	if(_pile_etats.size()<2)
		return false;
	auto etat1 = _pile_etats.top();
	_pile_etats.pop();
	auto etat2 = _pile_etats.top();
	_pile_etats.pop();
	_pile_etats.push(etat1);
	_pile_etats.push(etat2);
	return true;
}

bool PileEtats::rotation(const size_t niveau)
{
	if(niveau>_pile_etats.size())
		return false;
	decltype(_pile_etats) etatstemporaires;
	for(size_t index = 1 ; index<niveau ; ++index)
	{
		etatstemporaires.push(_pile_etats.top());
		_pile_etats.pop();
	}
	auto etat = _pile_etats.top();
	_pile_etats.pop();
	while(not etatstemporaires.empty())
	{
		_pile_etats.push(etatstemporaires.top());
		etatstemporaires.pop();
	}
	_pile_etats.push(etat);
	return true;
}

bool PileEtats::rotation_inverse(const size_t niveau)
{
	if(niveau>_pile_etats.size())
		return false;
	decltype(_pile_etats) etatstemporaires;
	auto etat = _pile_etats.top();
	_pile_etats.pop();
	for(size_t index = 2 ; index<=niveau ; ++index)
	{
		etatstemporaires.push(_pile_etats.top());
		_pile_etats.pop();
	}
	_pile_etats.push(etat);
	while(not etatstemporaires.empty())
	{
		_pile_etats.push(etatstemporaires.top());
		etatstemporaires.pop();
	}
	return true;
}

const size_t PileEtats::recherche(const SetLgg::Machine::Programme::Adresse& adresse)
{
	size_t niveau=1;
	for(auto it=_pile_etats.rbegin() ; it!=_pile_etats.rend() ; ++it,++niveau)
	{
		SetLgg::Machine::Programme::Adresse frame = *it;
		if(frame==adresse)
			break;
	}
	return niveau;
}

size_t PileEtats::taille()
{
	return _pile_etats.size();
}

