/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_PILEETAT_H_
#define _MACHINE_PROCESSEUR_PILEETAT_H_

#include <vector>
#include <src/machine/processeur/iterable_stack.h>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(PileEtats); } } }

#include <src/machine/processeur/etat.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Processeur
		{
			class PileEtats
			{
				public:
					PileEtats() = default;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const PileEtats&);
					void empile(const Etat& etat);
					Etat depile();
					bool duplique();
					bool elimine();
					bool echange();
					bool rotation(const size_t niveau);
					bool rotation_inverse(const size_t niveau);
					const size_t recherche(const SetLgg::Machine::Programme::Adresse& adresse);
					size_t taille();
				private:
					extended_std::iterable_stack<Etat,std::vector<Etat> > _pile_etats;
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const PileEtats& pileetat)
			{
				return os << "# State stack:" << std::endl << pileetat._pile_etats << "# End of state stack" << std::endl;
			}

			class TropDeRetoursDeFonction : public SetLgg::Global::Exception::Execution
			{
				public:
					TropDeRetoursDeFonction()
					:Execution(SIGILL,"Too much return instruction used")
					{ };
			};
		}
	}
}

#endif
