/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROCESSEUR_PROCESSEUR_H_
#define _MACHINE_PROCESSEUR_PROCESSEUR_H_

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Processeur { DECL_SHARED_PTR(Processeur); DECL_WEAK_PTR(Processeur); } } }

#include <src/machine/processeur/pileetats.h>
#include <src/machine/processeur/gestionnaireinterruptions.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { DECL_SHARED_PTR(Machine); }
		namespace Programme
		{
			DECL_SHARED_PTR(Programme);
			DECL_SHARED_PTR(Instruction);
			DECL_SHARED_PTR(Adresse);
			class Condition;
			class ConditionSecurite;
			template<typename S> class InstructionSecurite;
			class InstructionInterruption;
			class InstructionAllocation;
		}
		namespace Plugin { class Interface; }
		namespace Debogueur
		{
			class Debogueur;
		}
		namespace Processeur
		{
			class Processeur : public std::enable_shared_from_this<Processeur>
			{
				friend class Plugin::Interface;
				friend class Debogueur::Debogueur;
				friend class Programme::Condition;
				friend class Programme::ConditionSecurite;
				friend class GestionnaireInterruptions;
				friend class Programme::InstructionInterruption;
				friend class Programme::InstructionAllocation;
				template<typename S> friend class Programme::InstructionSecurite;
				public:
					enum class TypeExecution {NORMAL, DEBUG};
					Processeur() = default;
					static void enregistrement_signaux(ProcesseurSP& processeur)
					{
						GestionnaireInterruptions::enregistrement_signaux(processeur);
					};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Processeur&);
					template<TypeExecution type=TypeExecution::NORMAL>
					static void execution(SetLgg::Machine::Machine::MachineSP& machine);
					bool interruption(const size_t& interruption);
					bool modifier_interruption(const size_t& interruption, const SetLgg::Machine::Programme::AdresseSP& adresse);
					void appel(const SetLgg::Machine::Programme::Adresse& fonction, const SetLgg::Machine::Memoire::Adresse& parametres);
					void retour();
					void saut(const SetLgg::Machine::Programme::Adresse& label);
					const Etat& etat_courant() const
					{
						return _etat_courant;
					}
					void change_adresse_courante(const SetLgg::Machine::Memoire::Adresse& adresse)
					{
						_etat_courant.change_adresse_courante(adresse);
					}
					void ajoute_marqueur(const std::string& marqueur);
					void enleve_marqueur(const std::string& marqueur);
					bool presence_marqueur(const std::string& marqueur);
					void ajoute_allocation_memoire(const SetLgg::Machine::Memoire::Memoire::BlocMemoire& bloc);
					void ajoute_liberation_memoire(const SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire& blocs);
				private:
					Etat _etat_courant;
					PileEtats _pile_etats;
					GestionnaireInterruptions _interruptions;
					SetLgg::Machine::Programme::InstructionSP prochaine_instruction(const SetLgg::Machine::Programme::ProgrammeSP& programme);
					bool existe_interruption(const size_t& interruption) const
					{
						return static_cast<bool>(_interruptions[interruption]);
					};
					bool appel_interruption(const size_t& interruption);
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const Processeur& processeur)
			{
				return os << "# Processor:" << std::endl << processeur._etat_courant << processeur._pile_etats << processeur._interruptions << "# End of processor" << std::endl;
			}
		}
	}
}

#endif
