/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/analyseur/analyseur.h>
#define YYLTYPE SetLgg::Global::Source::Position
#include <src/machine/programme/analyseur/includes.h>
#include <src/machine/programme/analyseur/analyseur.syn.h>

#include <sys/stat.h>
#include <unistd.h>
#define FICHIER_STDIN "-"
#include <config.h>

using namespace SetLgg::Machine::Programme;

int programmeparse(SetLgg::Machine::Programme::Analyseur&, const SetLgg::Machine::Plugin::GestionnairePluginSP&, SetLgg::Machine::Debogueur::DebogueurSP&);
extern void* programme_scan_string(const char *);
int programmelex_destroy();
extern FILE* programmein;
extern SetLgg::Global::Source::Position programmelloc;

Analyseur::~Analyseur()
{
	::programmelex_destroy();
}

SetLgg::Machine::Programme::ProgrammeSP Analyseur::analyse_fichier(std::string source, const SetLgg::Machine::Plugin::GestionnairePluginSP& plugins, SetLgg::Machine::Debogueur::DebogueurSP& debogueur)
{
	Analyseur analyseur;
	analyseur._programme_source=source;
	if(analyseur._programme_source.empty())
		analyseur._programme_source=FICHIER_STDIN;
	programmein = Analyseur::ouvrir(analyseur._programme_source, programmelloc);
	analyseur._programme.reset(new Programme());
	if(::programmeparse(analyseur,plugins,debogueur))
	{
		if(analyseur._exception)
		{
			if(analyseur._programme_source!=FICHIER_STDIN)
			{
				::fclose(programmein);
			}
			analyseur._exception->banzai();
		}
		return ProgrammeSP();
	}
	if(analyseur._programme_source!=FICHIER_STDIN)
	{
		::fclose(programmein);
	}
	return analyseur._programme;
}

SetLgg::Machine::Programme::ProgrammeSP Analyseur::analyse_chaine(std::string source, const SetLgg::Machine::Plugin::GestionnairePluginSP& plugins, SetLgg::Machine::Debogueur::DebogueurSP& debogueur)
{
	Analyseur analyseur;
	analyseur._programme_source=source;
	::programme_scan_string(analyseur._programme_source.c_str());
	analyseur._programme.reset(new Programme());
	if(::programmeparse(analyseur,plugins,debogueur))
	{
		if(analyseur._exception)
		{
			analyseur._exception->banzai();
		}
		return ProgrammeSP();
	}
	return analyseur._programme;
}

bool Analyseur::teste_fichier(std::string fichier)
{
#ifdef TRACEUR_DEBUG
	std::cerr << "teste fichier " << fichier << std::endl;
#endif
	if(::access(fichier.c_str(),R_OK))
		return false;
#ifdef TRACEUR_DEBUG
	std::cerr << "access " << fichier << std::endl;
#endif
	struct stat buf;
	if(::stat(fichier.c_str(),&buf))
		return false;
#ifdef TRACEUR_DEBUG
	std::cerr << "stat " << fichier << std::endl;
#endif
	if(S_ISDIR(buf.st_mode))
		return false;
#ifdef TRACEUR_DEBUG
	std::cerr << "OK " << fichier << std::endl;
#endif
	return true;
}

FILE *Analyseur::ouvrir(std::string fichier, SetLgg::Global::Source::Position& position)
{
	SETLGG_TEST(not fichier.empty());
	if(fichier==FICHIER_STDIN)
	{
		position = SetLgg::Global::Source::Position(FICHIER_STDIN);
		return stdin;
	}

	if(not teste_fichier(fichier)) 
		throw SetLgg::Global::Exception::PasDeFichierSource(fichier);

	FILE *fic = ::fopen(fichier.c_str(),"r");
	position = SetLgg::Global::Source::Position(fichier);
	return fic;
}
