/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __ANALYSEUR_PROGRAMME_ANALYSEUR__
#define __ANALYSEUR_PROGRAMME_ANALYSEUR__
#include <cstdio>
#include <string>

#include <src/global/global.h>
namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Analyseur); } } }
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>
#include <src/machine/programme/donnees/programme.h>
#include <src/machine/debogueur/donnees/debogueur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Plugin
		{
			DECL_SHARED_PTR(GestionnairePlugin);
		}
		namespace Programme
		{
			class Analyseur
			{
				public:
					static ProgrammeSP analyse_fichier(std::string source, const SetLgg::Machine::Plugin::GestionnairePluginSP& plugins, SetLgg::Machine::Debogueur::DebogueurSP& debogueur);
					static ProgrammeSP analyse_chaine(std::string source, const SetLgg::Machine::Plugin::GestionnairePluginSP& plugins, SetLgg::Machine::Debogueur::DebogueurSP& debogueur);
					~Analyseur();
				private:
					Analyseur() {};
					std::string _programme_source;
					static FILE *ouvrir(std::string fichier, SetLgg::Global::Source::Position& position);
					static bool teste_fichier(std::string fichier);
				public:
					SetLgg::Machine::Programme::ProgrammeSP _programme;
					SetLgg::Global::Exception::GeneriqueSP _exception;
					
			};
		}
	}
}
#endif
