/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_ADRESSE_H_
#define _MACHINE_PROGRAMME_DONNEES_ADRESSE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Adresse); } } }

namespace SetLgg
{
	namespace Machine
	{
		namespace Plugin { class Interface; }
		namespace Debogueur { class Debogueur; }
		namespace Programme
		{
			class Programme;

			class Adresse
			{
				friend class Programme;
				friend class Plugin::Interface;
				friend class Debogueur::Debogueur;
				public:
					Adresse() :_adresse(0) {};
					explicit Adresse(size_t adresse) :_adresse(adresse) {};
					Adresse operator++()
					{
						++_adresse;
						return *this;
					};
					Adresse& operator+=(const Adresse& adresse)
					{
						_adresse+=adresse._adresse;
						return *this;
					};
					bool operator<(const Adresse& adresse) const
					{
						return _adresse<adresse._adresse;
					};
					bool operator<=(const Adresse& adresse) const
					{
						return _adresse<=adresse._adresse;
					};
					bool operator==(const Adresse& adresse) const
					{
						return _adresse==adresse._adresse;
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os, const Adresse& adresse)
					{
						os << "<" << adresse._adresse << ">";
						return os;
					};
				private:
					size_t _adresse;
					operator const size_t () const
					{
						return _adresse;
					};
			};
		}
	}
}
#endif
