/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIRE_H_
#define _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIRE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(AdresseMemoire); } } }

#include <src/machine/memoire/donnees/adresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { DECL_SHARED_PTR(Machine); }
		namespace Programme
		{
			class AdresseMemoire
			{
				public:
					AdresseMemoire() = default;
					virtual ~AdresseMemoire() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const AdresseMemoire&);
					virtual std::ostream& format(std::ostream& os) const =0;
					virtual SetLgg::Machine::Memoire::Adresse resolution(SetLgg::Machine::Machine::MachineSP& machine) const = 0;
					SetLgg::Machine::Memoire::AdresseSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						SetLgg::Machine::Memoire::AdresseSP adresse(new SetLgg::Machine::Memoire::Adresse(resolution(machine)));
						return adresse;
					}
					virtual void explication(std::ostream& os, SetLgg::Machine::Machine::MachineSP& machine, const size_t niveau=0) const
					{
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => ";
						SetLgg::Machine::Memoire::Adresse adresse = resolution(machine);
						os << (adresse) << std::endl;
					};
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const AdresseMemoire& adresse)
			{
				adresse.format(os);
				return os;
			};

		}
	}
}
#endif
