/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIREALIAS_H_
#define _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIREALIAS_H_

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(AdresseMemoireAlias); } } }

#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/memoire/donnees/alias.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class AdresseMemoireAlias : public AdresseMemoire
			{
				public:
					AdresseMemoireAlias(SetLgg::Machine::Memoire::Alias alias)
					:_alias(alias) {};
					virtual ~AdresseMemoireAlias() {};
					virtual SetLgg::Machine::Memoire::Adresse resolution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const AdresseMemoireAlias&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					SetLgg::Machine::Memoire::Alias _alias;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const AdresseMemoireAlias& adresse)
			{
				return os << adresse._alias;
			};
		}
	}
}
#endif
