/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIRECOURANTE_H_
#define _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIRECOURANTE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(AdresseMemoireCourante); } } }

#include <src/machine/programme/donnees/adressememoire.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class AdresseMemoireCourante : public AdresseMemoire
			{
				public:
					AdresseMemoireCourante() = default;
					virtual ~AdresseMemoireCourante() {};
					virtual SetLgg::Machine::Memoire::Adresse resolution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const AdresseMemoireCourante&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const AdresseMemoireCourante& adresse)
			{
				return os << ":current";
			};
		}
	}
}
#endif
