/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIREDECALAGE_H_
#define _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIREDECALAGE_H_

#include <sstream>
#include <src/global/global.h>

#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			template<typename Sens>
			class AdresseMemoireDecalage : public AdresseMemoire
			{
				public:
					AdresseMemoireDecalage(AdresseMemoireSP adresse, ValeurSP decalage)
					:_adresse(adresse),_decalage(decalage) {};
					virtual ~AdresseMemoireDecalage() {};
					SetLgg::Machine::Memoire::Adresse resolution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						SetLgg::Machine::Memoire::Adresse adresse = _adresse->resolution(machine);
						SetLgg::Machine::Memoire::ValeurCSP decalage = _decalage->evaluation(machine);
						return Sens::decalage(adresse,*decalage);
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os,const AdresseMemoireDecalage<Sens>& adresse)
					{
						return os << "( " << *(adresse._adresse) << " " << Sens::symbole() << " " << *(adresse._decalage) << " )";
					};
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					virtual void explication(std::ostream& os, SetLgg::Machine::Machine::MachineSP& machine, const size_t niveau=0) const
					{
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => ..." << std::endl;
						_adresse->explication(os,machine,niveau+1);
						_decalage->explication(os,machine,niveau+1);
						SetLgg::Machine::Memoire::Adresse adresse = resolution(machine);
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => " << (adresse) << std::endl;
					};
				private:
					AdresseMemoireSP _adresse;
					ValeurSP _decalage;
			};

			struct Incremente
			{
				static SetLgg::Machine::Memoire::Adresse decalage(const SetLgg::Machine::Memoire::Adresse& adresse, const SetLgg::Machine::Memoire::Valeur& decalage)
				{
					return adresse+decalage;
				};
				static std::string symbole() { return "+"; };
			};

			struct Decremente
			{
				static SetLgg::Machine::Memoire::Adresse decalage(const SetLgg::Machine::Memoire::Adresse& adresse, const SetLgg::Machine::Memoire::Valeur& decalage)
				{
					return adresse-decalage;
				};
				static std::string symbole() { return "-"; };
			};
		}
	}
}
#endif
