/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIREVALEUR_H_
#define _MACHINE_PROGRAMME_DONNEES_ADRESSEMEMOIREVALEUR_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(AdresseMemoireValeur); } } }

#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class AdresseMemoireValeur : public AdresseMemoire
			{
				public:
					AdresseMemoireValeur(const ValeurSP& valeur)
					:_valeur(valeur) {};
					virtual ~AdresseMemoireValeur() {};
					virtual SetLgg::Machine::Memoire::Adresse resolution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const AdresseMemoireValeur&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					virtual void explication(std::ostream& os, SetLgg::Machine::Machine::MachineSP& machine, const size_t niveau=0) const
					{
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => ..." << std::endl;
						_valeur->explication(os,machine,niveau+1);
						SetLgg::Machine::Memoire::Adresse adresse = resolution(machine);
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => " << (adresse) << std::endl;
					};
				private:
					SetLgg::Machine::Programme::ValeurSP _valeur;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const AdresseMemoireValeur& adresse)
			{
				return os << "&" << *(adresse._valeur);
			};

			class AdresseMemoireValeurConstante : public AdresseMemoireValeur
			{
				public:
					AdresseMemoireValeurConstante(const size_t adresse)
					:AdresseMemoireValeur(ValeurSP(new SetLgg::Machine::Memoire::Entier(adresse))), _adresse(adresse) {};
					virtual ~AdresseMemoireValeurConstante() {};
					virtual SetLgg::Machine::Memoire::Adresse resolution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return _adresse;
					};
					virtual void explication(std::ostream& os, SetLgg::Machine::Machine::MachineSP& machine, const size_t niveau=0) const
					{
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => ";
						SetLgg::Machine::Memoire::Adresse adresse = resolution(machine);
						os << (adresse) << std::endl;
					};
				private:
					SetLgg::Machine::Memoire::Adresse _adresse;
			};
		}
	}
}
#endif
