/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/blocmemoire.h>
using namespace SetLgg::Machine::Programme;

SetLgg::Machine::Memoire::Memoire::BlocMemoire BlocMemoire::operator() (SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::Adresse adresse = _adresse->resolution(machine);
	if(not _taille)
	{
		return SetLgg::Machine::Memoire::Memoire::BlocMemoire(adresse,1);
	}
	SetLgg::Machine::Memoire::ValeurCSP valeurtaille = _taille->evaluation(machine);
	SetLgg::Machine::Memoire::EntierCSP entiertaille = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Entier>(valeurtaille);
	if((*entiertaille)<0)
	{
		return SetLgg::Machine::Memoire::Memoire::BlocMemoire(adresse,0);
	}
	return SetLgg::Machine::Memoire::Memoire::BlocMemoire(adresse,(*entiertaille));
}

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire convertit(const ListeBlocsMemoire& listeblocsmemoire, SetLgg::Machine::Machine::MachineSP& machine)
			{
				SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire blocs;
				for(auto it=listeblocsmemoire.cbegin() ; it!=listeblocsmemoire.cend() ; ++it)
				{
					SetLgg::Machine::Memoire::Memoire::BlocMemoire bloc = (*it)(machine);
					if(bloc._taille>0)
					{
						blocs += bloc;
					}
				}
				return blocs;
			}
		}
	}
}
