/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_BLOCMEMOIRE_H_
#define _MACHINE_PROGRAMME_DONNEES_BLOCMEMOIRE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(BlocMemoire); } } }

#include <src/machine/memoire/donnees/memoire.h>
#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { DECL_SHARED_PTR(Machine); }
		namespace Programme
		{
			struct BlocMemoire
			{
				BlocMemoire(const AdresseMemoireSP& adresse, const ValeurSP& taille)
					:_adresse(adresse),_taille(taille) {};
				template<typename oStream>
					friend oStream& operator<<(oStream& os, const BlocMemoire& bloc)
					{
						os << *(bloc._adresse) ;
						if(bloc._taille)
						{
							os << " * " << *(bloc._taille);
						}
						return os;
					};
				SetLgg::Machine::Memoire::Memoire::BlocMemoire operator() (SetLgg::Machine::Machine::MachineSP& machine) const;
				AdresseMemoireSP _adresse;
				ValeurSP _taille;
			};

			typedef std::vector<BlocMemoire> ListeBlocsMemoire;
			
			template<typename oStream>
			oStream& operator<<(oStream& os, const ListeBlocsMemoire listeblocsmemoire)
			{
				for(auto it = listeblocsmemoire.cbegin() ; it!=listeblocsmemoire.cend() ; ++it)
				{
					if(it!=listeblocsmemoire.cbegin())
					{
						os << " , ";
					}
					os << (*it);
				}
				return os;
			}

			SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire convertit(const ListeBlocsMemoire& listeblocsmemoire, SetLgg::Machine::Machine::MachineSP& machine);

		}
	}
}
#endif
