/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_CONDITION_H_
#define _MACHINE_PROGRAMME_DONNEES_CONDITION_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Condition); } } }

#include <src/machine/memoire/donnees/valeur.h>
#include <src/machine/memoire/donnees/booleen.h>
#include <src/machine/machine/machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionSaut;
			class InstructionRetour;
			class InstructionArret;
			class InstructionClone;

			class Condition
			{
				friend class InstructionSaut;
				friend class InstructionRetour;
				friend class InstructionArret;
				friend class InstructionClone;
				public:
					Condition()
					:_dans_un_saut(false), _test(true) {};
					virtual ~Condition() {};
					const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						SetLgg::Machine::Memoire::BooleenCSP booleen(new SetLgg::Machine::Memoire::Booleen(evaluation_booleene(machine)));
						return booleen;
					};
					const bool evaluation_booleene(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return _test==evaluation_booleene_interne(machine);
					}
					void negation()
					{
						_test = false;
					};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Condition&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os;
					};
					template<typename oStream>
					oStream& clause(oStream& os) const
					{
						if(_dans_un_saut)
						{
							if(_test)
							{
								os << " :when ";
							}
							else
							{
								os << " :unless ";
							}
						}
						return os;
					}
				protected:
					bool _dans_un_saut;
					bool _test;
				private:
					virtual const bool evaluation_booleene_interne(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return true;
					};
					void est_dans_un_saut()
					{
						_dans_un_saut = true;
					};
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Condition& condition)
			{
				return condition.format(os);
			};
		}
	}
}
#endif
