/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_DEREFERENCEADRESSE_H_
#define _MACHINE_PROGRAMME_DONNEES_DEREFERENCEADRESSE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(DereferenceAdresse); } } }

#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class DereferenceAdresse : public Valeur
			{
				public:
					DereferenceAdresse(AdresseMemoireSP adresse)
					:_adresse(adresse),_type_voulu(SetLgg::Machine::Memoire::Type::tous()) {}
					virtual ~DereferenceAdresse() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const DereferenceAdresse&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					virtual void type_voulu(const SetLgg::Machine::Memoire::Type& type_voulu)
					{
						_type_voulu=type_voulu;
					};
					virtual operator const SetLgg::Machine::Memoire::Type&() const
					{
						return SetLgg::Machine::Memoire::Type::tous();
					};
					virtual const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const;
					virtual operator SetLgg_Machine_Value() const
					{
						throw;
					};
					virtual void explication(std::ostream& os, SetLgg::Machine::Machine::MachineSP& machine, const size_t niveau=0) const
					{
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => ..." << std::endl;
						_adresse->explication(os,machine,niveau+1);
						SetLgg::Machine::Memoire::ValeurCSP valeur = evaluation(machine);
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => " << (*valeur) << std::endl;

					};
				private:
					AdresseMemoireSP _adresse;
					SetLgg::Machine::Memoire::Type _type_voulu;
					virtual SetLgg::Machine::Memoire::ValeurSP copie() const
					{
						SetLgg::Machine::Memoire::ValeurSP valeur(new DereferenceAdresse(*this));
						return valeur;
					};
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const DereferenceAdresse& valeur)
			{
				return os << "@" << *(valeur._adresse);
			};
		}
	}
}
#endif
