/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_EXPRESSION_H_
#define _MACHINE_PROGRAMME_DONNEES_EXPRESSION_H_

#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Expression); } } }

#include <src/machine/memoire/donnees/entier.h>
#include <src/machine/memoire/donnees/chaine.h>
#include <src/machine/memoire/donnees/booleen.h>
#include <src/machine/memoire/donnees/adresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { class Machine; }
		namespace Programme
		{
			class Expression
			{
				public:
					Expression() = default;
					virtual ~Expression() {};
					virtual const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const = 0;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Expression&);
					virtual std::ostream& format(std::ostream& os) const =0;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Expression& expression)
			{
				return expression.format(os);
			};
		}
	}
}
#endif
