/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_FORMAT_H_
#define _MACHINE_PROGRAMME_DONNEES_FORMAT_H_

#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Format); } } }

#include <src/machine/memoire/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class Format
			{
				public:
					Format(std::string format) :_format(format) {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Format&);
					std::string operator() (const SetLgg::Machine::Memoire::ValeurCSP& valeur) const;
					SetLgg::Machine::Memoire::ValeurSP operator() (const std::string& valeur) const;
					SetLgg::Machine::Memoire::ValeurSP convertit(const SetLgg::Machine::Memoire::ValeurCSP& valeur) const;
					SetLgg::Machine::Memoire::ValeurSP valeur_nulle() const;
				private:
					std::string _format;
					static bool represente_un_entier(std::string chaine);
					static std::string conversion_format(const std::string& format);
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Format& format)
			{
				return os << "~" << format._format;
			};
			
			class FormatInvalide : public SetLgg::Global::Exception::Execution
			{
				public:
					FormatInvalide()
					:Execution(SIGILL,"Invalid format") {};
			};

			class DonneesInvalidesPourFormat : public SetLgg::Global::Exception::Execution
			{
				public:
					DonneesInvalidesPourFormat(const std::string& valeur, const std::string& format)
					:Execution(SIGABRT,std::string("Value ")+valeur+" can not be formatted with format ~"+format) {};
			};
		}
	}
}
#endif
