/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTION_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTION_H_

#include <src/global/global.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Instruction); } } }

#include <src/machine/programme/donnees/programme.h>
#include <src/machine/memoire/donnees/memoire.h>
#include <src/machine/memoire/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { DECL_SHARED_PTR(Machine); }
		namespace Programme
		{
			class Instruction
			{
				public:
					Instruction(const SetLgg::Global::Source::PositionSP& position)
					:_position(position) {};
					virtual ~Instruction() {};
					virtual void edition_liens(ProgrammeSP programme) { };
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						execution_avec_resultat(machine);
					}; 
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						std::ostringstream oss;
						format(oss);
						throw SetLgg::Global::Exception::InstructionIllegale(oss.str());
					}; 
					virtual operator SetLgg::Global::Source::PositionSP () const
					{
						return _position;
					};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Instruction&);
					explicit operator std::string () const
					{
						std::ostringstream oss;
						format(oss);
						return oss.str();
					};

					virtual std::ostream& format(std::ostream&) const =0 ;
				protected:
					SetLgg::Global::Source::PositionSP _position;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Instruction& instruction)
			{
				return instruction.format(os);
			}
		}
	}
}
#endif
