/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONAFFECTATION_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONAFFECTATION_H_

#include <src/global/global.h>

#include <src/machine/programme/donnees/instructionaffectationgenerique.h>
#include <src/machine/machine/machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			template<typename InstructionSpeciale>
			class InstructionAffectation: public InstructionAffectationGenerique
			{
				public:
					InstructionAffectation(const SHARED_PTR(InstructionSpeciale)& instruction, const AdresseMemoireSP& adresse, const SetLgg::Global::Source::PositionSP& position)
					:InstructionAffectationGenerique(adresse,position), _instruction(instruction) {};
					virtual ~InstructionAffectation() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						SetLgg::Machine::Memoire::ValeurCSP valeur = _instruction->execution_avec_resultat(machine);
						SetLgg::Machine::Memoire::AdresseSP adresse = _adresse->evaluation(machine);
						machine->_memoire->ecriture(*adresse,valeur);
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os,const InstructionAffectation<InstructionSpeciale>& instruction)
					{
						return os << *(instruction._instruction) << " -> " << *(instruction._adresse);
					};
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					SHARED_PTR(InstructionSpeciale) _instruction;
			};
			
		}
	}
}
#endif
