/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONAFFECTATIONGENERIQUE_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONAFFECTATIONGENERIQUE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionAffectationGenerique); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/adressememoire.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionAffectationGenerique: public Instruction
			{
				public:
					InstructionAffectationGenerique(const AdresseMemoireSP& adresse, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _adresse(adresse) {};
					virtual ~InstructionAffectationGenerique() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionAffectationGenerique&);
					virtual std::ostream& format(std::ostream& os) const =0 ;
				protected:
					AdresseMemoireSP _adresse;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionAffectationGenerique& instruction)
			{
				return instruction.format(os);
			};
		}
	}
}
#endif
