/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONALLOCATION_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONALLOCATION_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionAllocation); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/placememoire.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionAllocation: public Instruction
			{
				public:
					typedef std::vector<PlaceMemoire> ListePlacesMemoire;
					InstructionAllocation(const ListePlacesMemoire& liste_places_memoire, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _liste_places_memoire(liste_places_memoire) {};
					virtual ~InstructionAllocation() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						execution_avec_resultat(machine);
					};
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionAllocation&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					ListePlacesMemoire _liste_places_memoire;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionAllocation& instruction)
			{
				os << ":new ";
				for(auto it=instruction._liste_places_memoire.cbegin() ; it!=instruction._liste_places_memoire.cend() ; ++it)
				{
					if(it!=instruction._liste_places_memoire.cbegin())
					{
						os << " , ";
					}
					os << (*it);
				}
				return os;
			};
		}
	}
}
#endif
