/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionappel.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/chaine.h>
using namespace SetLgg::Machine::Programme;

void InstructionAppel::edition_liens(ProgrammeSP programme)
{
	SETLGG_TEST(programme);
	if(not _label_dynamique)
	{
		_destination = programme->lien_statique(_label_statique,_position);
	}
}

void InstructionAppel::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::AdresseSP parametres  = _parametres->evaluation(machine);
	if(_label_dynamique)
	{
		SetLgg::Machine::Memoire::ValeurCSP valeur = _label_dynamique->evaluation(machine);
		SetLgg::Machine::Memoire::ChaineCSP chaine = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeur);
		Label label(*chaine);
		Adresse destination = machine->_programme->lien_dynamique(label);
		machine->_processeur->appel(destination,*parametres);
	}
	else
	{
		machine->_processeur->appel(_destination,*parametres);
	}
}
