/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONAPPEL_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONAPPEL_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionAppel); } } }

#include <src/machine/programme/donnees/programme.h>
#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/label.h>
#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/programme/donnees/dereferenceadresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionAppel: public Instruction
			{
				public:
					InstructionAppel(const Label& label_statique, const AdresseMemoireSP& parametres, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _label_statique(label_statique), _parametres(parametres) {};
					InstructionAppel(const ValeurSP& label_dynamique, const AdresseMemoireSP& parametres, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _label_dynamique(label_dynamique), _parametres(parametres) {};
					virtual ~InstructionAppel() {};
					virtual void edition_liens(ProgrammeSP programme);
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionAppel&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					ValeurSP _label_dynamique;
					Label _label_statique;
					AdresseMemoireSP _parametres;
					Adresse _destination;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionAppel& instruction)
			{
				os << ":call ";
				if(instruction._label_dynamique)
				{
					os << *(instruction._label_dynamique);
				}
				else
				{
					os << instruction._label_statique;
				}
				os << " " << *(instruction._parametres);
#ifdef SETLGG_DEBUG
				os << " # " << instruction._destination;
#endif
				return os;
			};
		}
	}
}
#endif
