/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionarret.h>
#include <src/machine/machine/machine.h>
using namespace SetLgg::Machine::Programme;

void InstructionArret::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	if(_condition->evaluation_booleene(machine))
	{
		if(not _code_arret)
		{
			machine->arret(false,true,0);
		}
		else
		{
			SetLgg::Machine::Memoire::ValeurCSP valeurcodearret = _code_arret->evaluation(machine);
			SetLgg::Machine::Memoire::EntierCSP codearret = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Entier>(valeurcodearret);
			long long int code = (*codearret);
			machine->arret(false,code>=0,(code<0)?(-code):code);
		}
	}
}
