/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONARRET_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONARRET_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionArret); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/programme/donnees/condition.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionArret: public Instruction
			{
				public:
					InstructionArret(const ValeurSP& code_arret, const ConditionSP& condition, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _code_arret(code_arret), _condition(condition)
					{
						_condition->est_dans_un_saut();
					};
					InstructionArret(const ConditionSP& condition, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _condition(condition)
					{
						_condition->est_dans_un_saut();
					};
					virtual ~InstructionArret() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionArret&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
				private:
					ValeurSP _code_arret;
					ConditionSP _condition;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionArret& instruction)
			{
				os << ":shutdown";
				if(instruction._code_arret)
				{
					os << " " << *(instruction._code_arret);
				}
				if(instruction._condition)
				{
					os << " " << *(instruction._condition);
				}
				return os;
			};
		}
	}
}
#endif
