/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <unistd.h>
#include <src/machine/programme/donnees/instructionattente.h>
#include <src/machine/memoire/donnees/entier.h>
#include <src/machine/machine/machine.h>
using namespace SetLgg::Machine::Programme;

void InstructionAttente::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::ValeurCSP attente = _secondes->evaluation(machine);
	SetLgg::Machine::Memoire::EntierCSP secondes = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Entier>(attente);
	long int attentesecondes = *secondes;
	bool interruptible = false;
	if(attentesecondes<0)
	{
		attentesecondes = -attentesecondes;
		interruptible = true;
	}
	for(auto attenteencours=static_cast<unsigned int>(attentesecondes) ; attenteencours>0 ; )
	{
		attenteencours = ::sleep(attenteencours);
		if(interruptible)
			return;
	}
}
