/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONATTENTE_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONATTENTE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionAttente); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionAttente: public Instruction
			{
				public:
					InstructionAttente(const ValeurSP& secondes, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _secondes(secondes) {};
					virtual ~InstructionAttente() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionAttente&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					ValeurSP _secondes;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionAttente& instruction)
			{
				return os << ":wait " << *(instruction._secondes);
			};

			class AttenteNegative : public SetLgg::Global::Exception::Execution
			{
				public:
					AttenteNegative(const std::string& attente)
					:Execution(SIGILL,std::string("Negative wait time ")+attente+" invalid") { };
			};
		}
	}
}
#endif
