/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <sys/select.h>
#include <cerrno>

#include <src/machine/programme/donnees/instructionattenteflux.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/chaine.h>
#include <src/machine/programme/donnees/nomflux.h>
#include <src/machine/flux/gestionnaireflux.h>

using namespace SetLgg::Machine::Programme;
SetLgg::Machine::Memoire::ValeurSP InstructionAttenteFlux::execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const
{
	typedef std::map<size_t,std::pair<SetLgg::Machine::Memoire::NomFluxSP,SetLgg::Machine::Flux::FluxSP> > ListeFlux;
	ListeFlux listeflux;
	size_t fd_max=0;

	SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire blocsmemoire = SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire::agregation(convertit(_flux,machine));
	
	fd_set fdset_origine;
	fd_set fdset;
	FD_ZERO(&fdset_origine);

	for(auto it=blocsmemoire.cbegin() ; it!=blocsmemoire.cend() ; ++it)
	{
		SetLgg::Machine::Memoire::Adresse debut = it->_adresse;
		SetLgg::Machine::Memoire::Adresse fin = it->_adresse+it->_taille;
		for(SetLgg::Machine::Memoire::Adresse adresse = debut ; adresse<fin ; ++adresse)
		{
			SetLgg::Machine::Memoire::ValeurCSP nom_flux_brut = machine->_memoire->lecture(adresse,SetLgg::Machine::Memoire::Type::TypeValeur::NOM_FLUX);
			SetLgg::Machine::Memoire::NomFluxCSP nom_flux_intermediaire = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::NomFlux>(nom_flux_brut);
			SetLgg::Machine::Memoire::NomFlux nom_flux = *nom_flux_intermediaire;
			SetLgg::Machine::Flux::FluxSP flux = (*machine->_flux)[nom_flux];
			if(not flux)
			{
				throw SetLgg::Machine::Flux::FluxInexistant(nom_flux);
			}
			size_t fd;
			switch(_sens)
			{
				case SetLgg::Machine::Flux::TypeOuvertureFichier::LECTURE:
					{
						SetLgg::Machine::Flux::TypeLecture type_lecture = (*_mode)(machine);
						if(flux->pret_a_lire(type_lecture,false))
						{
#ifdef SETLGG_DEBUG
							SETLGG_TRACE << " flux: " << nom_flux << " donnees deja presentes" << std::endl;
#endif
							SetLgg::Machine::Memoire::NomFluxSP nom_flux_pret(new SetLgg::Machine::Memoire::NomFlux(nom_flux));
							return nom_flux_pret;
						}
						fd=flux->descripteur_lecture();
					}
					break;
				case SetLgg::Machine::Flux::TypeOuvertureFichier::ECRITURE:
					fd=flux->descripteur_ecriture();
					break;
				default:
					throw;
					break;
			}
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "fd: " << fd << " flux: " << nom_flux << std::endl;
#endif
			FD_SET(fd,&fdset_origine);
			listeflux[fd] = ListeFlux::mapped_type(SetLgg::Machine::Memoire::NomFluxSP(new SetLgg::Machine::Memoire::NomFlux(nom_flux)),flux);
			if(fd>fd_max)
			{
				fd_max=fd;
			}
		}
		
	}
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "fd max: " << fd_max << std::endl;
#endif
	int fdres;
	for(;;)
	{
		fdset=fdset_origine;
		switch(_sens)
		{
			case SetLgg::Machine::Flux::TypeOuvertureFichier::LECTURE:
				fdres = ::select(fd_max+1,&fdset,NULL,NULL,NULL);
				break;
			case SetLgg::Machine::Flux::TypeOuvertureFichier::ECRITURE:
				fdres = ::select(fd_max+1,NULL,&fdset,NULL,NULL);
				break;
			default:
				throw;
				break;
		}

#ifdef SETLGG_DEBUG
SETLGG_TRACE << "fd res: " << fdres << std::endl;
#endif
		if(fdres<0)
		{
			switch(errno)
			{
				case EINTR:
				case EBADF:
					{
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "Erreur EINTR ou EBADF" << std::endl;
#endif
						SetLgg::Machine::Memoire::NomFluxSP nom_flux_nul(new SetLgg::Machine::Memoire::NomFluxNul());
						return nom_flux_nul;
					}
					break;
				default:
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "Erreur autre" << std::endl;
#endif
					{
						std::ostringstream details;
						details << SetLgg::Global::Exception::details << std::endl << "select: " << ::strerror(errno);
						throw AttenteFluxIncorrecte(details.str());
					}
			}
		}
		for(size_t it=0 ; it<fd_max+1 ; ++it)
		{
			if(FD_ISSET(it,&fdset))
			{
				if(listeflux.find(it)==listeflux.end())
					continue;
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "Suspecte fd: " << it << " flux: " << *((listeflux[it]).first) << std::endl;
#endif
				SetLgg::Machine::Flux::TypeLecture type_lecture = (*_mode)(machine);
				if(listeflux[it].second->pret_a_lire(type_lecture))
				{
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "Renvoie fd: " << it << " flux: " << *((listeflux[it]).first) << std::endl;
#endif
					return listeflux[it].first;
				}
			}
		}

	}
	throw;
}
